 ; Ŀ
 ;   Squa - Adjust attribute widths by grid size.                          
 ;   Copyright 1995, 1997, 1999 - 2008 by Rocket Software Ltd.             
 ;   Many people are unaware that whelks exist.                            
 ; 

 ; Ŀ
 ;   Subroutine Cress - squeeze or stretch attributes as required.         
 ;   Arguments: Enam, an attribute ename.                                  
 ;              Widd, the allowable actual width, without end gaps.        
 ;              Ideal, the ideal desired width scale factor.               
 ; 
 (DEFUN CRESS (enam widd ideal / entt realwd widscl prev41 widd scalfc)
  (setq entt (entget enam))
 ; Ŀ
 ;   Call Wits to find the actual string width.                            
 ; 
  (setq realwd (wits entt))
 ; Ŀ
 ;   Find the attribute width scale factor.                                
 ; 
  (setq widscl (cdr (setq prev41 (assoc 41 entt))))
 ; Ŀ
 ;   The actual allowable space is widd - 2 x 0.8 x text height.           
 ; 
  (setq widd (- widd (* 1.6 (cdr (assoc 40 entt)))))
 ; Ŀ
 ;   Compare the actual and desired widths.                                
 ;   If the actual width is greater than the space then crush the          
 ;   attribute to fit.                                                     
 ; 
  (cond ((> realwd widd)
         (setq scalfc (/ widd realwd))
         (setq widscl (* widscl scalfc))
         (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   Should see if the width scale is greater than ideal - if so then      
 ;   set it to ideal.                                                      
 ;   The previous condition checked to see if it was too wide, so don't    
 ;   have to do that here.                                                 
 ;   This should only happen if someone has done something odd.            
 ; 
        ((> widscl ideal)
         (entmod (subst (cons 41 ideal) prev41 entt)))
 ; Ŀ
 ;   See if the attribute is narrower than it should be.                   
 ;   If setting the width scale factor to the desired value would leave    
 ;   the attibute wider than the allowable space, then increase it just    
 ;   to fill the space.                                                    
 ; 
        ((< widscl ideal)
         (if (> (* realwd (/ ideal widscl)) widd)
                (progn
                     (setq scalfc (/ widd realwd))
                     (setq widscl (* widscl scalfc))
                     (entmod (subst (cons 41 widscl) prev41 entt)))
 ; Ŀ
 ;   Otherwise set it to the ideal width scale value.                      
 ; 
                (entmod (subst (cons 41 ideal) prev41 entt)))))
 (princ))
 ; Ŀ
 ;   Cress end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Cstar - draw an individual grstar (centred).               
 ;   Takes four arguments: centre point, side length, rotation (radians),  
 ;   and colour.  Returns nothing, but draws a star.                       
 ; 
 (DEFUN CSTAR (pa sidlen rota colo / anginc angg hafang pb)
  (setq pa (polar pa (+ rota (/ pi 2)) (* sidlen 1.37638192)))
  (setq anginc (* 1.6 pi))
  (setq angg (+ rota (* 1.6 pi)))
  (setq hafang (* 0.8 pi))
  (repeat 5
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg anginc))
         (setq pa pb)
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg hafang))
         (setq pa pb))
 (princ))
 ; Ŀ
 ;   Subroutine Cstar end.                                                 
 ; 

 ; Ŀ
 ;   Flinn - Find the closest line to a point in a given direction.        
 ;   Arguments: Siz - the pickbox size.                                    
 ;              Base, the start point.                                     
 ;              Movinc, the distance to move between searches.             
 ;              Dir, the direction to move, in radians.                    
 ;   Stops looking after 1000 tries.                                       
 ;   Returns a list: a point or nil if no frame entities were found.       
 ; 
 (DEFUN FLINN (siz base movinc dir / num pandp ss enam pop typ entt)
  (setq rad (/ (getvar "viewsize") 100))
  (setq num 0)
  (while (and (< num 1000) (null ss))
 ; Ŀ
 ;   Pan the point onto the screen if neccessary.                          
 ; 
         (setq pandp (screu base))          ; set a global flag
         (if (null pand) (setq pand pandp)) ; but don't set to nil if t
 ; Ŀ
 ;   See if there was anything there that might be a box.                  
 ; 
         (setq ss (ssget base '((-4 . "<or") (0 . "polyline") (0 . "circle")
                                (0 . "ellipse") (0 . "insert") (0 . "text")
                                (0 . "line") (0 . "lwpolyline") (-4 . "or>"))))
 ; Ŀ
 ;   Check to see if the entity in question was an attribute or text.      
 ;   Want to stop at a line or polyline in an insert, but not an           
 ;   attribute or text.  (Embedded text which laps over a line is          
 ;   with luck very unlikely.  Probably.)                                  
 ;   If this is the case then we aren't dealing with the test block,       
 ;   because it has already been emptied, so empty the new block or text   
 ;   entity, measure again, and restore it.                                
 ; 
         (if (and ss
                 (setq enam (ssname ss 0))
                 (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
                 (or (= typ "TEXT")
                     (and
                        (= typ "INSERT")
                        (setq sstyp (nentselp base))
                        (setq sstyp (cdr (assoc 0 (entget (car sstyp)))))
                        (member sstyp '("TEXT" "ATTRIB")))))
             (progn
 ; Ŀ
 ;   Vanoo empties and restores the text or insert, Cstar draws a grstar.  
 ; 
                  (vanoo enam)
                  (cstar (cdr (assoc 10 entt)) rad 0 140)
                  (setq ss (ssget base '((-4 . "<or")
                                         (0 . "polyline") (0 . "circle")
                                         (0 . "ellipse") (0 . "insert")
                                         (0 . "line") (0 . "lwpolyline")
                                         (-4 . "or>"))))
                  (vanoo enam)))
 ; Ŀ
 ;   Draw an indicator box.                                                
 ; 
         (pbd base siz)
         (setq num (1+ num))
         (setq base (polar base dir movinc)))
  (if ss
      (progn
           (setq pop (osnap base "nearest"))
           (if pop (setq base pop)))
      (setq base nil))
 ; (grdraw '(0 0) base 1)
 base)
 ; Ŀ
 ;   Flinn end.                                                            
 ; 

 ; Ŀ
 ;   Pbd - draw a pseudo-pickbox.                                          
 ;   Arguments: Ppa, a centre point.                                       
 ;              Siz, a size.                                               
 ;   Calls nothing, returns four corner points.                            
 ; 
 (DEFUN PBD (ppa siz / dist ll ul lr ur)
  (setq dist (sqrt (* 2 (/ siz 2) (/ siz 2))))
  (setq ll (polar ppa (* pi 1.25) dist))
  (setq ul (polar ppa (* pi 0.75) dist)) 
  (setq lr (polar ppa (* pi 1.75) dist))
  (setq ur (polar ppa (* pi 0.25) dist))
 ; Ŀ
 ;   We now have the four real corner points of the pickbox.               
 ; 
  (grdraw ll ul -1)
  (grdraw ul ur -1)
  (grdraw ur lr -1)
  (grdraw lr ll -1)
 ; Ŀ
 ;   Force the display to draw the grlines.                                
 ; 
  (princ)
 (list ll ul ur lr))
 ; Ŀ
 ;   Pbd end.                                                              
 ; 

 ; Ŀ
 ;   Pksiz - find the pickbox size in drawing units.                       
 ;   Contains a nameless flaw correction (size is 1/2 what it should be.)  
 ; 
 (DEFUN PKSIZ (/ pbsize vsize scsize pixis)
  (setq pbsize (getvar "pickbox"))       ; pickbox size in pixels
  (setq vsize (getvar "viewsize"))       ; view height in dwg units
  (setq scsize (getvar "screensize"))    ; view ht/wid in pixels
  (setq pixis (/ vsize (cadr scsize)))   ; 1 pixel in dwg units
 (* pbsize pixis 2))                     ; pickbox size in dwg units
 ; Ŀ
 ;   Pksiz end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Screu: if a point isn't onscreen, pan it on.  Just.        
 ;   Takes one argument, a point.                                          
 ;   Calls nothing.                                                        
 ;   Returns T if the screen was panned, else nil.                         
 ; 
 (DEFUN SCREU (pa / scrnsz scrat vhhght ctr vhwid maxx minx maxy miny pax pay
                                                           panux panuy panned)
 ; Ŀ
 ;   Get the screen size variables.                                        
 ; 
  (setq scrnsz (getvar "screensize"))         ; view height & width (pixels)
  (setq scrat (/ (car scrnsz) (cadr scrnsz))) ; view width/height ratio
  (setq vhhght (/ (getvar "viewsize") 2.0))   ; view half height in dwg units
  (setq ctr (getvar "viewctr"))               ; centre point of screen
  (setq vhwid (* vhhght scrat))               ; view halfwidth
 ; Ŀ
 ;   Find the minimum and maximum x and y coordinates.                     
 ; 
  (setq maxx (+ (car ctr) vhwid))
  (setq minx (- (car ctr) vhwid))
  (setq maxy (+ (cadr ctr) vhhght))
  (setq miny (- (cadr ctr) vhhght))
 ; Ŀ
 ;   If the point pa isn't onscreen, pan it back on (by 5%).               
 ; 
  (setq pax (car pa))
  (setq pay (cadr pa))
  (cond ((> pax maxx)
         (setq panux (+ (car ctr) (* 0.9 vhwid))))
        ((< pax minx)
         (setq panux (- (car ctr) (* 0.9 vhwid)))))
  (cond ((> pay maxy)
         (setq panuy (+ (cadr ctr) (* 0.9 vhhght))))
        ((< pay miny)
         (setq panuy (- (cadr ctr) (* 0.9 vhhght)))))
  (if (or panux panuy)
      (progn
           (setq panned t)
           (if (null panux) (setq panux pax))
           (if (null panuy) (setq panuy pay))
           (command ".pan" pa (list panux panuy))))
 panned)
 ; Ŀ
 ;   Screu end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Tarare: get the width of the space an attribute ocupies.   
 ;   Arguments: Enam, the entity name of the attribute.                    
 ;              Siz, the pickbox size in drawing units.                    
 ;   Returns a distance or nil if something went wrong.                    
 ; 
 (DEFUN TARARE (enam siz / entt txht txang movinc ptlist ll ur pa paleft
                                                                  parigt widd)
  (setq entt (entget enam))
  (setq txht (cdr (assoc 40 entt)))
  (setq txang (cdr (assoc 50 entt)))
  (setq movinc (* (pksiz) 0.5))
 ; Ŀ
 ;   Find the midpoint of the text.  Ptlist is '(ll ul ur lr)              
 ; 
  (setq ptlist (tbx enam))
  (setq ll (car ptlist))
  (setq ur (caddr ptlist))
  (setq pa (list (/ (+ (car ll) (car ur)) 2)
                 (/ (+ (cadr ll) (cadr ur)) 2)))
 ; Ŀ
 ;   Try to find a frame type entity - a line, pline, circle, block, etc.  
 ;   - on each side of the text.                                           
 ; 
  (if (and (setq paleft (flinn siz pa movinc (+ txang pi)))
           (setq parigt (flinn siz pa movinc txang)))
      (setq widd (distance paleft parigt)))
 ; Ŀ
 ;   Return the width or nil.                                              
 ; 
 widd)
 ; Ŀ
 ;   Subroutine Tarare end.                                                
 ; 

 ; Ŀ
 ;   Tbx - text extents locator and outliner.                              
 ; 
 (DEFUN TBX (enam / aa bb rota cc dd bheigt bwidth llangg lldist ll ul lr ur)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assuming that the    
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   We now have the real upper left, upper right, etc. points of the      
 ;   text.                                                                 
 ; 
;  (grdraw ll ul -1)
;  (grdraw ul ur -1)
;  (grdraw ur lr -1)
;  (grdraw lr ll -1)
 (list ll ul ur lr))
 ; Ŀ
 ;   Tbx end.                                                              
 ; 

 ; Ŀ
 ;   Vanoo - empty a text entity or all attributes in an insert and save   
 ;   the values to a list for later reinsertion, unless the entity name    
 ;   is already present in the list, in which case reapply the values and  
 ;   remove the ename from the list.                                       
 ;   Argument: Enam, the block or text entity ename.                       
 ;   The ename and value list is global within the main routine.           
 ;   Calls nothing, Returns nothing, but has its suspicions.               
 ; 
 (DEFUN VANOO (enam / typ sub subf esav pos entt enam vall gnulis)
  (setq esav enam)
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (if (setq sub (assoc enam valis))
      (setq subf t)) ; flag: value data found
 ; Ŀ
 ;   Cond 1: the entity is a block and the ename is present in the list,   
 ;   reapply the values.                                                   
 ; 
  (cond ((and (= typ "INSERT") sub)
         (setq pos 1)      ; pos 0 was enam
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                             (setq enam (entnext enam)))))))
                (setq vall (nth pos sub))
                (setq pos (1+ pos))
                (entmod (subst (cons 1 vall) (assoc 1 entt) entt)))
         (entupd esav))
 ; Ŀ
 ;   Cond 2: the entity is text and the ename is present in the list,      
 ;   reapply the value.                                                    
 ; 
        ((and (= typ "TEXT") sub)
         (entmod (subst (cons 1 (cadr sub)) (assoc 1 entt) entt)))
 ; Ŀ
 ;   Cond 3: the entity is a block and the ename isn't present in the      
 ;   list, empty the block and save the attribute values to valis.         
 ; 
        ((= typ "INSERT")
         (setq sub (list enam))
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                             (setq enam (entnext enam)))))))
                (setq vall (cdr (assoc 1 entt)))
                (setq sub (cons vall sub))
                (entmod (subst (cons 1 "") (assoc 1 entt) entt)))
         (entupd esav)
         (setq valis (cons (reverse sub) valis)))
 ; Ŀ
 ;   Cond 4: the entity is text and the ename isn't present in the list,   
 ;   empty the text and save the value to valis.                           
 ; 
        ((= typ "TEXT")
         (setq sub (list enam (cdr (assoc 1 entt))))
         (entmod (subst (cons 1 " ") (assoc 1 entt) entt))
         (setq valis (cons sub valis))))
 ; Ŀ
 ;   If Subf is set then a data sublist was found and we just restored     
 ;   values to a block or text, so remove the used sublist from valis.     
 ; 
  (if subf
     (progn
          (while (setq sub (car valis))
                 (setq valis (cdr valis))
                 (if (not (equal (car sub) esav))
                     (setq gnulis (cons sub gnulis))))
          (setq valis gnulis)))
 (princ))
 ; Ŀ
 ;   Vanoo end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Wits - find the width of an attribute.                     
 ;   Takes one argument: the attribute entity data list.  Returns a width. 
 ; 
 (DEFUN WITS (entt / tblist cc dd bwidth)
  (setq tblist (textbox entt))
  (setq cc (car tblist))                    ; ll offset from 10 of text
  (setq dd (cadr tblist))                   ; ur offset from 10 of text
  (setq bwidth (- (car dd) (car cc))))
 ; Ŀ
 ;   Wits end.                                                             
 ; 

 ; Ŀ
 ;   Squa.                                                                 
 ; 
 (DEFUN C:SQUA (/ ctr osmo *error* siz ss asoc2 enam entt atnam atwid wilist
                                                              valis num esav)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq ctr (getvar "viewctr"))    ; centre point of screen
  (setq pand nil)                  ; set global haven't panned flag
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
 (defun *error* (shk)
  (setvar "osmode" osmo)
  (command "undo" "end")
  (while (setq sub (car valis))
         (vanoo (car sub)))
  (if shk (print shk))
 (princ))
 ; Ŀ
 ;   Get the pickbox size.                                                 
 ; 
  (setq siz (pksiz))
 ; Ŀ
 ;   Get an ss of blocks.  The first one will be used for spacing.         
 ;   Any which don't match it will be deleted.  Maybe.                     
 ; 
  (if (setq ss (ssget '((0 . "insert") (66 . 1))))
      (progn
           (setq asoc2 (assoc 2 (entget (setq enam (ssname ss 0)))))
           (setq ss (ssget "p" (list asoc2)))
 ; Ŀ
 ;   Get the list of space lengths for the attributes in the first block.  
 ;   First empty the block.                                                
 ; 
           (setq esav enam)
           (vanoo enam)
           (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
                  (setq atnam (cdr (assoc 2 entt)))
 ; Ŀ
 ;   Get the width of the current attribute.                               
 ; 
                  (setq atwid (tarare enam siz))
                  (setq wilist (cons (list atnam atwid) wilist)))
 ; Ŀ
 ;   Replace the attribute values - de-empty the block.                    
 ; 
           (vanoo esav)
 ; Ŀ
 ;   Adjust the attributes in all selected blocks.                         
 ; 
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (setq esav enam)
                  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
                         (setq atnam (cdr (assoc 2 entt)))
                         (setq atwid (cadr (assoc atnam wilist)))
                         (cress enam atwid 1.0))
                  (entupd esav))))
 ; Ŀ
 ;   End neatly.                                                           
 ; 
  (if pand (command ".pan" ctr (getvar "viewctr")))
  (*error* ())
 (princ))